#include "parsedemo_q2.h"
#include "c:\games\quake2\src\q_shared.h"

parsedemo_q2::parsedemo_q2(char* in_buf, long in_buf_len)
{
	buf		= in_buf;
	buf_len	= in_buf_len;
	block_count = 0;
}

parsedemo_q2::~parsedemo_q2()
{
}

void parsedemo_q2::log (demodata* in_data, configdata* in_config) 
{
	data = in_data;
	config = in_config;
	bool nodemo = false;
	buf_pos = buf;
	while (buf_pos < buf+buf_len) {
		block_size = msg->ReadLong (&buf_pos);
		if (block_size == 0xFFFFFFFF) {
			break;
		}
		block_count++;
//		printf ("\nAnalyzing block %i", block_count); // DEBUG
		analyzeBlock ();
		buf_pos += block_size;
	}
}

void parsedemo_q2::analyzeBlock () 
{
#include "q2mldefs.h"
	bool updated_pos;
	bool rename = false;
	unsigned char id = 0;
	static unsigned char prev_id;
	static int current_map = -1;
	char* pos = buf_pos;
	while ((pos < buf_pos+block_size) && (pos < buf+buf_len)){
		prev_id = id;
		id = msg->ReadByte (&pos);
		switch (id) {
		case '\x00':
			err->msg_and_exit ("Q2ML: Unknown demo format (pos: 0x%X this_id: 0x%X prev_id: 0x%X)!", (pos-buf), id, prev_id);
			break;
		case '\x01':
			entity = msg->ReadShort (&pos);
			value = msg->ReadByte (&pos);
			break;
		case '\x02':
			entity = msg->ReadShort (&pos);
			value = msg->ReadByte (&pos);
			break;
		case '\x03':
			entitytype = msg->ReadByte (&pos);
			switch (entitytype) {
				// point entity
			case Q2_TE_EXPLOSION1:
			case Q2_TE_EXPLOSION2:
			case Q2_TE_ROCKET_EXPLOSION:
			case Q2_TE_GRENADE_EXPLOSION:
			case Q2_TE_ROCKET_EXPLOSION_WAQ2_TER:
			case Q2_TE_GRENADE_EXPLOSION_WAQ2_TER:
			case Q2_TE_BFG_EXPLOSION:
			case Q2_TE_BFG_BIGEXPLOSION:
			case Q2_TE_BOSSTPORT:
			case Q2_TE_28:
				msg->ReadPosition(&pos, origin);
				break;
				// impact entity
			case Q2_TE_GUNSHOT:
			case Q2_TE_BLOOD:
			case Q2_TE_BLASQ2_TER:
			case Q2_TE_SHOTGUN:
			case Q2_TE_SPARKS:
			case Q2_TE_SCREEN_SPARKS:
			case Q2_TE_SHIELD_SPARKS:
			case Q2_TE_BULLET_SPARKS:
			case Q2_TE_GREENBLOOD:
				msg->ReadPosition(&pos, origin);
				msg->ReadDir(&pos, movedir);
				break;
				// line entity
			case Q2_TE_BUBBLETRAIL:
			case Q2_TE_BFG_LASER:
			case Q2_TE_PLASMATRAIL:
				msg->ReadPosition(&pos, origin);
				msg->ReadPosition(&pos, trace_endpos);
				break;
				// WEAPON EFFICIENCY
			case Q2_TE_RAILTRAIL:
				msg->ReadPosition(&pos, origin);
				msg->ReadPosition(&pos, trace_endpos);
				// Entfernung der player_origins von Gerade?
//				printf ("\nrailtrail: %f,%f,%f - %f,%f,%f", 
//					origin[0], origin[1], origin[2], 
//					trace_endpos[0], trace_endpos[1], trace_endpos[2]);
				for (i = 0; i < 12; i++) {
					double a = (trace_endpos[0] - origin[0]) / last_origin[i][0];
					double b = (trace_endpos[1] - origin[1]) / last_origin[i][1];
					double c = (trace_endpos[2] - origin[2]) / last_origin[i][2];
//					printf ("\na: dest: %i %f,%f,%f", i+1,
//						last_origin[i][0], last_origin[i][1], last_origin[i][2]);
				}
				break;
				//-- WEAPON EFFICIENCY
				// special entity
			case Q2_TE_SPLASH:
				count = msg->ReadByte (&pos);
				msg->ReadPosition(&pos, origin);
				msg->ReadDir(&pos, movedir);
				sounds = msg->ReadByte (&pos);
				break;
			case Q2_TE_LASER_SPARKS:
			case Q2_TE_WELDING_SPARKS:
			case Q2_TE_29:
				count = msg->ReadByte (&pos);
				msg->ReadPosition(&pos, origin);
				msg->ReadDir(&pos, movedir);
				color = msg->ReadByte (&pos);
				break;
			case Q2_TE_PARASIQ2_TE_ATTACK:
			case Q2_TE_MEDIC_CABLE_ATTACK:
				entity = msg->ReadShort (&pos);
				msg->ReadPosition(&pos, origin);
				msg->ReadPosition(&pos, trace_endpos);
				break;
			case Q2_TE_GRAPPLE_CABLE:
				entity = msg->ReadShort (&pos);
				msg->ReadPosition(&pos, origin);
				msg->ReadPosition(&pos, trace_endpos);
				msg->ReadPosition(&pos, offset);
				break;
			default:
//				err->msg_and_exit ("Unknown entity!");
				return;
				break;
			}
			break;
			case '\x04':
				msg->ReadString (&pos);
				break;
			case '\x05':
				for (i = 0 ; i < MAX_IQ2_TEMS ; i++) inventory[i] = msg->ReadShort (&pos);
				break;
			case '\x06':
			case '\x07':
			case '\x08':
				break;
			case '\x09':
				mask = msg->ReadByte (&pos);
				soundnum = msg->ReadByte (&pos);
				vol = (mask & 0x01) ? ((float)msg->ReadByte (&pos) / 255.0) : (1.0);
				attenuation = (mask & 0x02) ? ((float)msg->ReadByte (&pos) / 64.0) : (1.0);
				timeofs = (mask & 0x10) ? ((float)msg->ReadByte (&pos) * 0.001) : (0.0);
				if (mask & 0x08) {
					entity_channel = msg->ReadShort (&pos);
					entity = (entity_channel >> 3);
					channel = entity_channel & 0x07;
					if (entity > MAX_EDICTS) {
						err->msg_and_exit ("Too many entities!");
					}
				} else {
					channel = 0;
					entity = 0;
				}
				if (mask & 0x04) {
					msg->ReadPosition (&pos, origin);
				}
				
				break;
			case '\x0A': // MESSAGES
				level = msg->ReadByte (&pos);
				string = msg->ReadString (&pos);
				misc->strlow (string);
				if ((config->is_lmctf == false) && (config->is_battle == false)) {
//					printf ("frame %i: %s", block_count, string); // DEV
					data->add (block_count, level, string, 0);
				} else {
					if (level == 2) {
						level = 1;
					}
					data->add (block_count, level, string, 0);
				}
				break;
			case '\x0B': // STUFFTEXT
				char* text;
				text = msg->ReadString (&pos);
				break;
			case '\x0C':
				serverversion = msg->ReadLong (&pos);
				key = msg->ReadLong (&pos);
				isdemo = msg->ReadByte (&pos);
				game = msg->ReadString (&pos);
				client = msg->ReadShort (&pos);
				mapname = msg->ReadString (&pos);
				data->add (block_count, 102, game, 0);
				if (strncmp (game, "lmctf", 5) == 0) {
					config->is_lmctf = true; // LMCTF demo
					config->no_claninfo = true; // LMCTF demo
				} if (strncmp (game, "battle", 6) == 0) {
					config->is_battle = true; // Battleground demo
					config->no_claninfo = true; // Battleground demo
				} 
				data->add (block_count, 6, mapname, 0);
				break;
			case '\x0D':
				index = msg->ReadShort (&pos);
				string = msg->ReadString (&pos);
				if (index == 33) {
					i = strlen (string);
					while (string[--i] != '/');
					strcpy (string, string+i+1);
					data->add (block_count, 4, _strupr (string), 0);
				} 
				else if ((index > 1311) && (index < 1567)) { // ???
					misc->strlow (string);
					char* temp = new char[strlen(string)+64];
//					printf ("\n%s [%i]", string, index-1311); // DEV
					data->add (block_count, 5, string, index-1311);
					delete[] temp;
				}
				break;
			case '\x0E':
				mask = msg->ReadByte (&pos);
				if (mask & 0x00000080) mask |= (msg->ReadByte (&pos) <<	8);
				if (mask & 0x00008000) mask |= (msg->ReadByte (&pos) << 16);
				if (mask & 0x00800000) mask |= (msg->ReadByte (&pos) << 24);
				entity = (mask & 0x00000100) ? msg->ReadShort (&pos) : msg->ReadByte (&pos);
				if (mask & 0x00000800) modelindex = msg->ReadByte (&pos);
				if (mask & 0x00100000) modelindex2 = msg->ReadByte (&pos);
				if (mask & 0x00200000) modelindex3 = msg->ReadByte (&pos);
				if (mask & 0x00400000) modelindex4 = msg->ReadByte (&pos);
				if (mask & 0x00000010) frame = msg->ReadByte (&pos);
				if (mask & 0x00020000) frame = msg->ReadShort (&pos);
				if (mask & 0x00010000) {
					if (mask & 0x02000000) skin = msg->ReadLong (&pos);
					else skin = msg->ReadByte (&pos);
				}
				else {
					if (mask & 0x02000000) skin = msg->ReadShort (&pos);
				}
				vwep = skin >> 8;
				skin &= 0xFF;
				if (mask & 0x00004000) {
					if (mask & 0x00080000) effects = msg->ReadLong (&pos);
					else effects = msg->ReadByte (&pos);
				}
				else {
					if (mask & 0x00080000) effects = msg->ReadShort (&pos);
				}
				if (mask & 0x00001000) {
					if (mask & 0x00040000) renderfx = msg->ReadLong (&pos);
					else renderfx = msg->ReadByte (&pos);
				}
				else {
					if (mask & 0x00040000) renderfx = msg->ReadShort (&pos);
				}
				if (mask & 0x00000001) origin[0] = msg->ReadCoord (&pos);
				if (mask & 0x00000002) origin[1] = msg->ReadCoord (&pos);
				if (mask & 0x00000200) origin[2] = msg->ReadCoord (&pos);
				if (mask & 0x00000400) angles[0] = msg->ReadAngle (&pos);
				if (mask & 0x00000004) angles[1] = msg->ReadAngle (&pos);
				if (mask & 0x00000008) angles[2] = msg->ReadAngle (&pos);
				if (mask & 0x01000000) msg->ReadPosition(&pos, old_origin);
				if (mask & 0x04000000) sound = msg->ReadByte (&pos);
				event = (mask & 0x00000020) ? msg->ReadByte (&pos) : 0;
				if (mask & 0x08000000) solid = msg->ReadShort (&pos);
				break;
			case '\x0F':
				text = msg->ReadString (&pos);
				break;
			case '\x10':
				blocksize = msg->ReadShort (&pos);
				percent= msg->ReadByte (&pos);
				if (serverversion >= 32) { /* from version 3.15 on */
					for ( i=0 ; i<block_size ; i++ ) {
						msg->ReadByte (&pos);
					}
				}
				break;
			case '\x11':
				mask = msg->ReadShort (&pos);
				if (mask & 0x0001) pm_type = msg->ReadByte (&pos);
				if (mask & 0x0002)
					msg->ReadPosition(&pos, origin); 
				if (mask & 0x0004)
					msg->ReadPosition(&pos, velocity);
				if (mask & 0x0008) teleport_time = msg->ReadByte (&pos);
				if (mask & 0x0010) pm_flags = msg->ReadByte (&pos);
				if (mask & 0x0020) gravity = msg->ReadShort (&pos);
				if (mask & 0x0040) {
					delta_angles[0] = msg->ReadAngle16 (&pos);
					delta_angles[1] = msg->ReadAngle16 (&pos);
					delta_angles[2] = msg->ReadAngle16 (&pos);
				}
				if (mask & 0x0080) {
					viewoffset[0] = msg->ReadChar (&pos) / 4.0;
					viewoffset[1] = msg->ReadChar (&pos) / 4.0;
					viewoffset[2] = msg->ReadChar (&pos) / 4.0;
				}
				if (mask & 0x0100) {
					viewangles[0] = msg->ReadAngle16 (&pos);
					viewangles[1] = msg->ReadAngle16 (&pos);
					viewangles[2] = msg->ReadAngle16 (&pos);
				}
				if (mask & 0x0200) {
					kick_angles[0] = msg->ReadChar (&pos) / 4.0;
					kick_angles[1] = msg->ReadChar (&pos) / 4.0;
					kick_angles[2] = msg->ReadChar (&pos) / 4.0;
				}
				if (mask & 0x1000) gunindex = msg->ReadByte (&pos);
				if (mask & 0x2000) {
					gunframe = msg->ReadByte (&pos);
					gunoffset[0] = msg->ReadChar (&pos) / 4.0;
					gunoffset[1] = msg->ReadChar (&pos) / 4.0;
					gunoffset[2] = msg->ReadChar (&pos) / 4.0;
					gunangles[0] = msg->ReadChar (&pos) / 4.0;
					gunangles[1] = msg->ReadChar (&pos) / 4.0;
					gunangles[2] = msg->ReadChar (&pos) / 4.0;
				}
				if (mask & 0x0400) {
					blend[0] = msg->ReadByte (&pos) / 255.0;
					blend[1] = msg->ReadByte (&pos) / 255.0;
					blend[2] = msg->ReadByte (&pos) / 255.0;
					blend[3] = msg->ReadByte (&pos) / 255.0;
				}
				if (mask & 0x0800) fov = msg->ReadByte (&pos);
				if (mask & 0x4000) rdflags = msg->ReadByte (&pos);
				mask2 = msg->ReadLong (&pos);
				for (i=0;i<32;i++) if (mask2 & (0x00000001 << i)) stats[i] = msg->ReadShort (&pos);
				// Hier Health[1]/Ammo[3]/Armor[5]/Pickup[8]/Frags[14] ...
				// ... /Flashes(Health,Armor)[15]/Spectator[17]
				break;
			case '\x12':
				// Werte von allen Spielern/Entities
				for (;;) {
					mask = msg->ReadByte (&pos);
					if (mask & 0x00000080) mask |= ((msg->ReadByte (&pos)) << 8);
					if (mask & 0x00008000) mask |= ((msg->ReadByte (&pos)) << 16);
					if (mask & 0x00800000) mask |= ((msg->ReadByte (&pos)) << 24);
					entity = (mask & 0x00000100) ? (msg->ReadShort (&pos)) : msg->ReadByte (&pos);
					if (entity >= MAX_EDICTS) err->msg_and_exit ("entity >= MAX_EDICTS");
					if (entity == 0) break;
					xremove = (mask & 0x00000040) ? 1 : 0;
					if (mask & 0x00000800) modelindex = msg->ReadByte (&pos);
					if (mask & 0x00100000) modelindex2 = msg->ReadByte (&pos);
					if (mask & 0x00200000) modelindex3 = msg->ReadByte (&pos);
					if (mask & 0x00400000) modelindex4 = msg->ReadByte (&pos);
					if (mask & 0x00000010) frame = msg->ReadByte (&pos);
					if (mask & 0x00020000) frame = msg->ReadShort (&pos);
					if (mask & 0x00010000) {
						if (mask & 0x02000000) skin = msg->ReadLong (&pos);
						else skin = msg->ReadByte (&pos);
					}
					else {
						if (mask & 0x02000000) skin = msg->ReadShort (&pos);
					}
					vwep = skin >> 8;
					skin &= 0xFF;
					if (mask & 0x00004000) {
						if (mask & 0x00080000) effects = msg->ReadLong (&pos); 
						else effects = msg->ReadByte (&pos);
						if (effects == EF_QUAD) {
							data->add (block_count, 222, entity); // quad entity
						}
					}
					else {
						if (mask & 0x00080000) {
							effects = msg->ReadShort (&pos); 
							if (effects == EF_QUAD) {
								data->add (block_count, 222, entity); // quad entity
							}
						}
					}
					if (mask & 0x00001000) {
						if (mask & 0x00040000) renderfx = msg->ReadLong (&pos);
						else renderfx = msg->ReadByte (&pos);
					}
					else {
						if (mask & 0x00040000) renderfx = msg->ReadShort (&pos);
					}
					updated_pos = false;
					if (mask & 0x00000001) {
						origin[0] = msg->ReadCoord (&pos);
						last_origin[entity][0] = origin[0];
						updated_pos = true;
					}
					if (mask & 0x00000002) {
						origin[1] = msg->ReadCoord (&pos);
						last_origin[entity][1] = origin[1];
						updated_pos = true;
					}
					if (mask & 0x00000200) {
						origin[2] = msg->ReadCoord (&pos);
						last_origin[entity][2] = origin[2];
						updated_pos = true;
					}
					if (mask & 0x00000400) angles[0] = msg->ReadAngle (&pos);
					if (mask & 0x00000004) angles[1] = msg->ReadAngle (&pos);
					if (mask & 0x00000008) angles[2] = msg->ReadAngle (&pos);
					if (mask & 0x01000000) msg->ReadPosition(&pos, old_origin);
					if (mask & 0x04000000) sound = msg->ReadByte (&pos);
					event = (mask & 0x00000020) ? (msg->ReadByte (&pos)) : 0;
					if (mask & 0x08000000) solid = msg->ReadShort (&pos);
					if (config->write_ways_and_kills_graph == true) {
						if (updated_pos == true) {
							if ((entity == client+1) || (config->graph_all_clients == true)) {
								data->add (block_count, 111, 
									&last_origin[entity][0], 
									&last_origin[entity][1], 
									&last_origin[entity][2],
									entity);
							}
						}
					}
				}
				break;
			case '\x13':
				break;
			case '\x14': 
//				return; // no frags after this msg type
				if (isdemo == RECORD_CLIENT || isdemo == RECORD_NETWORK) {
					seq1 = msg->ReadLong (&pos);
					seq2 = msg->ReadLong (&pos);
					if (serverversion != 26) uk_b1 = msg->ReadByte (&pos);
					count = msg->ReadByte (&pos);
					for (i=0;i<count;i++) areas[i] = msg->ReadByte (&pos);
				}
				if (isdemo == RECORD_SERVER) {
					frame = msg->ReadLong (&pos);
				}
				break;
			default:
				err->msg_and_exit ("Q2ML: Unknown demo format (pos: 0x%X this_id: 0x%X prev_id: 0x%X sv_version: %i)!", (pos-buf), id, prev_id, serverversion);
				break;
		}
	}	
}
